//=============================================================================
// Switch2, used to be anyways.
//=============================================================================
class MSCCardScanner extends DeusExDecoration;

#exec TEXTURE IMPORT NAME="CardScannerGray" FILE="C:\DeusEx\MarkistanCity\Textures\CardScannerGray.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CardScannerGreen" FILE="C:\DeusEx\MarkistanCity\Textures\CardScannerGreen.pcx" GROUP=Skins

#exec MESH IMPORT MESH=CardScanner ANIVFILE=MODELS\CardScanner_a.3d DATAFILE=MODELS\CardScanner_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CardScanner X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=CardScanner SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CardScanner SEQ=CardScanner STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=CardScanner MESH=CardScanner
#exec MESHMAP SCALE MESHMAP=CardScanner X=0.0214850 Y=0.0214850 Z=0.0214850

#exec MESHMAP SETTEXTURE MESHMAP=CardScanner NUM=0 TEXTURE=CardScannerGray
#exec MESHMAP SETTEXTURE MESHMAP=CardScanner NUM=1 TEXTURE=CardScannerGreen

var float GreenLeft;
var() class<inventory> CardTypeNeeded, SubCardType;
var() string GrantedMsg, DeniedMsg, Used1, Used2;
var() bool bDest1, bDest2;
var() float OpenTime;

var bool bLocked;

function Tick(float D)
{
 local DeusExMover DXM;

 Super.Tick(D);
 
 if (GreenLeft > 0)
 {
  Texture = Texture'AlarmLightTex4';
  GreenLeft -= D;
  LightHue = 84;
 }

 if (GreenLeft <= 0)
 {
  if (!bLocked)
  {
   bLocked = True;

   if (Event != '')
   {
    forEach AllActors(class'DeusExMover', DXM, Event)
    {
     DXM.DoClose();
     DXM.bLocked = DXM.bInitialLocked;
     DXM.LockStrength = DXM.InitialLockStrength; 
    }
   }
  }
  LightHue = 0;
  Texture = Texture'AlarmLightTex2';
 }
}

function Frob(Actor Frobber, Inventory frobWith)
{
	local DeusExMover DXM;

	if (( (DeusExPlayer(Frobber).inHand.class != CardTypeNeeded) && (DeusExPlayer(Frobber).inHand.class != SubCardType)) || (CardTypeNeeded == None) || (SubCardType == None && DeusExPlayer(Frobber).inHand.class == SubCardType))
	{
         if (DeniedMsg ~= "")
	 {
	  Pawn(Frobber).ClientMessage("|cf88Please insert proper card for scanning.");
	 }
	 if (DeniedMsg != "")
	 {
	  Pawn(Frobber).ClientMessage("|cf88 "$DeniedMsg$"");
	 }
	 PlaySound(sound'Beep6',SLOT_Interface,128,True,128);
	 return;
	}

	if ( (DeusExPlayer(Frobber).inHand.class == CardTypeNeeded) || (DeusExPlayer(Frobber).inHand.class == SubCardType) )
	{
         if (GrantedMsg ~= "")
	 {
	  Pawn(Frobber).ClientMessage("|p3Access Granted.");
	 }
         if (GrantedMsg != "")
	 {
	  Pawn(Frobber).ClientMessage("|p3"$GrantedMsg$"");
	 }
	 
	 if (DeusExPlayer(Frobber).inHand.class == CardTypeNeeded && bDest1)
	 {
	  DeusExPlayer(Frobber).inHand.Destroy();
          DeusExPlayer(Frobber).ClientMessage(Used1);
	 }

	 if (DeusExPlayer(Frobber).inHand.class == SubCardType && bDest2)
	 {
	  DeusExPlayer(Frobber).inHand.Destroy();
          DeusExPlayer(Frobber).ClientMessage(Used2);
	 }

	 GreenLeft = OpenTime;
	 bLocked = False;
	 PlaySound(sound'Beep2',SLOT_Interface,128,True,128);
	}

	Super.Frob(Frobber, frobWith);
	
	if (Event != '')
        {
	 forEach AllActors(class'DeusExMover', DXM, Event)
	 {
	  //DXM.Trigger(Frobber, DeusExPlayer(Frobber));
	  DXM.bLocked = DXM.bInitialLocked; //a shitty hack so it re-locks the door it triggers,
	  DXM.LockStrength = DXM.InitialLockStrength; //important so others can't follow you in.
	 }
        }
}

defaultproperties
{
     bInvincible=True
     ItemName="Card Scanner"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'CardScanner'
     DrawScale=0.450000
     CollisionRadius=5.260000
     CollisionHeight=5.940000
     Mass=10.000000
     Buoyancy=12.000000
     OpenTime=1.750000
     LightType=LT_Steady
     LightRadius=6
     LightBrightness=70
     LightHue=0
     LightSaturation=0
}
